#extension GL_OES_standard_derivatives : enable

varying highp vec2 v_vTex;

varying lowp vec3 v_vGlyphColor;
varying lowp vec3 v_vOutlineColor;

uniform sampler2D glu_samplerTex;

// Distance at wich we switch.
varying lowp float v_vGlyphCenter;
varying lowp float v_vOutlineCenter;

void main(void)
{
	mediump float distance = texture2D(glu_samplerTex, v_vTex).a;
//	mediump float smoothWidth = fwidth(distance);
	mediump float smoothWidth = 0.10;
	mediump float alpha;
	mediump vec3 rgb;

	mediump float mu = smoothstep(v_vGlyphCenter - smoothWidth,
	                              v_vGlyphCenter + smoothWidth,
	                              distance);

	rgb = mix(v_vOutlineColor, v_vGlyphColor, mu);

	alpha = smoothstep(v_vOutlineCenter - smoothWidth,
	                   v_vOutlineCenter + smoothWidth,
	                   distance);


	gl_FragColor = vec4(rgb, alpha);
}
