#extension GL_OES_standard_derivatives : enable

varying lowp vec4  v_vCol;
varying highp vec2 v_vTex;
uniform sampler2D glu_samplerTex;

const  mediump vec3 GlyphColor = vec3(0.0, 0.0, 0.0);
const  mediump vec3 GlowColor = vec3(1.0,1.0,1.0);

const mediump float SmoothCenter = 0.5;
const mediump float GlowBoundary = 0.7;

void main(void)
{
	mediump vec4 color = texture2D(glu_samplerTex, v_vTex);
	mediump float distance = color.a;
	mediump float smoothWidth = fwidth(distance);
	mediump float alpha;
	mediump vec3 rgb;

	mediump float mu = smoothstep(SmoothCenter - smoothWidth,
											SmoothCenter + smoothWidth,
											distance);

	rgb = mix(GlowColor, GlyphColor, mu);
	alpha = smoothstep(SmoothCenter, GlowBoundary, sqrt(distance));

	gl_FragColor = vec4(rgb, alpha);
}
